/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.registries;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.yuushya.registries.YuushyaRegistryData;
import com.yuushya.utils.GsonTools;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class YuushyaRegistryConfig {
    private static YuushyaRegistryData YuushyaData;
    public static final Map<String, YuushyaRegistryData.Block> YuushyaRawBlockMap;
    public static final Map<String, YuushyaRegistryData.Item> YuushyaRawItemMap;
    public static final Map<String, YuushyaRegistryData.Particle> YuushyaRawParticleMap;
    public static final InputStream InnerFileInputStream;
    public static final File CONFIG_FILE;
    public static final String VERSION;
    private static final Map<String, JsonObject> BlockClass;

    public static void addResultToRawMap(YuushyaRegistryData from) {
        if (from.block != null) {
            from.block.forEach(e -> YuushyaRawBlockMap.put(e.name, (YuushyaRegistryData.Block)e));
        }
        if (from.item != null) {
            from.item.forEach(e -> YuushyaRawItemMap.put(e.name, (YuushyaRegistryData.Item)e));
        }
        if (from.particle != null) {
            from.particle.forEach(e -> YuushyaRawParticleMap.put(e.name, (YuushyaRegistryData.Particle)e));
        }
    }

    public static void readRegistrySelf() {
        YuushyaRegistryConfig.readRegistryInner();
        YuushyaRegistryConfig.addResultToRawMap(YuushyaData);
    }

    public static void readRegistryConfig() {
        if (!CONFIG_FILE.exists()) {
            YuushyaRegistryConfig.readRegistryInner();
            YuushyaRegistryConfig.addResultToRawMap(YuushyaData);
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(CONFIG_FILE));){
            JsonElement configJson = JsonParser.parseReader((Reader)reader);
            YuushyaRegistryConfig.mergeYuushyaRegistryBlockJson(configJson.getAsJsonObject().getAsJsonArray("block"));
            YuushyaRegistryData yuushyaRegistryData = (YuushyaRegistryData)GsonTools.NormalGSON.fromJson(configJson, YuushyaRegistryData.class);
            if (yuushyaRegistryData.version.equals(VERSION)) {
                YuushyaRegistryConfig.addResultToRawMap(yuushyaRegistryData);
            } else {
                YuushyaRegistryConfig.readRegistryInner();
                YuushyaRegistryConfig.addResultToRawMap(yuushyaRegistryData);
                YuushyaRegistryConfig.addResultToRawMap(YuushyaData);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void readRegistryInner() {
        if (InnerFileInputStream != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(InnerFileInputStream));){
                JsonElement innerJson = JsonParser.parseReader((Reader)reader);
                YuushyaRegistryConfig.mergeYuushyaRegistryBlockJson(innerJson.getAsJsonObject().getAsJsonArray("block"));
                YuushyaData = (YuushyaRegistryData)GsonTools.NormalGSON.fromJson(innerJson, YuushyaRegistryData.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void mergeYuushyaRegistryBlockJson(JsonArray blockList) {
        blockList.forEach(block -> {
            JsonObject blockObject = block.getAsJsonObject();
            String classType = blockObject.get("class_type").getAsString();
            if ("class".equals(classType)) {
                BlockClass.put(blockObject.get("name").getAsString(), blockObject);
            } else if (BlockClass.containsKey(classType)) {
                try {
                    GsonTools.extendJsonObject(blockObject, GsonTools.ConflictStrategy.PREFER_FIRST_OBJ, BlockClass.get(classType));
                }
                catch (GsonTools.JsonObjectExtensionConflictException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    static {
        YuushyaRawBlockMap = new LinkedHashMap<String, YuushyaRegistryData.Block>();
        YuushyaRawItemMap = new LinkedHashMap<String, YuushyaRegistryData.Item>();
        YuushyaRawParticleMap = new LinkedHashMap<String, YuushyaRegistryData.Particle>();
        InnerFileInputStream = YuushyaRegistryConfig.class.getResourceAsStream("/data/yuushya/register/inner.json");
        CONFIG_FILE = Platform.getConfigFolder().resolve("com.yuushya/register.json").toFile();
        VERSION = Platform.getMod((String)"yuushya").getVersion();
        BlockClass = new HashMap<String, JsonObject>();
    }
}

